<?php

/*
* @category    360Dialog - WhatsApp Class
* @package     Nube Apps
* @author      Jorge Ancizar Galeano Ruiz<jorgegaleano@nubeapps.com.co>
* @copyright   2021 Jorge Ancizar Galeano Ruiz
* @version     Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   573168345866
*/

require("../../../core/php/_database.php");
session_start();

//Define Variables
//$menuPrincipalOptions = array("1", "2", "x", "X");

class DIALOG360{
    private $API_URL;
    private $API_WEBHOOK;
    private $URL_WEBHOOK;
    private $API_TOKEN;
    private $API_HEADER;
    
    public $PROCESSS_STATE;
    public $idWSPOFI;
    public $response_api;
    public $input_request;
    
    public $type_obj;
    public $isMessage = "false";
    public $isContext = "false";
    public $isText = "false";
    public $isVideo = "false";
    public $isImage = "false";
    public $isDocument = "false";
    public $from_id;
    public $transaction_id;
    public $context_from_id;
    public $context_transaction_id;
    public $timestamp_mov;
    public $type_id;
    public $media_id;
    public $media_mime_type;
    public $media_sha256;
    public $media_caption;
    public $media_filename;
    public $answer;
    public $profile_name;
    public $wsp_id;
    
    public $recipient_id;
    public $status_id;
    public $question;
    public $contact;
    public $to_id;
    
    public $Paciente;
    public $Cliente;
    public $CAS;
    public $FechaAct;
    public $isBeginChat = "false";
    public $idchat_question;
    public $txtBodyToSend;
    public $rootId;
    public $questionMsg;
    public $questionOpt;
    public $questionNextRoot;
    public $txtQuestionOpt;
    public $typeAnswer;
    public $questionTxt;
    public $questionTimestamp;
    
    public $patientDocument;
    public $patientName;
    public $patientFirstName;
    public $patientToId;
    public $Genero;
    public $FecNac;
    public $WSPValido;
    public $Exento;
    public $patientCliente;
    public $patientEstado;
    public $patientExisteBD;
    public $patientBeginChat;
	
    public $seloptionId = 0;
    public $seloptionTitle = "";
    public $seloptionFunction = "";
    public $seloptionNextRoot = "";
	
    public $isEndProcess = "false";
	
    public function __construct(){
        $gBaseDatos = new ofiMySQLi();
        $qry = "CALL sp_360dialog_get_paramsconnect()";
        $gBaseDatos->conectar();
        $paramFields = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->API_URL = $paramFields[0];
        $this->API_WEBHOOK = $paramFields[2];
        $this->API_TOKEN = $paramFields[1];
        $this->URL_WEBHOOK = array(
            'url' => '$paramFields[3]'
        );
        $this->API_HEADER = array(
            "Content-Type: application/json",
            "D360-Api-Key: $this->API_TOKEN",
        );
    }

    function getAuthentication(){
        $payload = json_encode($this->URL_WEBHOOK);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->API_WEBHOOK,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $this->API_HEADER,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $this->PROCESSS_STATE = 0;
            $responseAPI = $err;
        } else {
            $this->PROCESSS_STATE = 1;
            $responseAPI = $response;
        }
        return $responseAPI;
    }
    
    function validateBeginChat(){
        $this->isBeginChat = "0";
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_360dialog_validate_beginchat("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->isBeginChat = $responseQry[0];
    }
    
    function sendMsg(){
        $numCel = $this->wsp_id;
        $data = array(
            "to" => "$numCel",
            "type" => "text",
            "text" => array (
                "body" => $this->txtBodyToSend
            )
        );
        $payload = json_encode($data);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->API_URL,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $this->API_HEADER,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $this->PROCESSS_STATE = 0;
            $responseAPI = $err;
        } else {
            $this->PROCESSS_STATE = 1;
            $responseAPI = $response;
        }
        return $responseAPI;
    }
    
    function sendQuestion(){
        $this->txtBodyToSend = $this->questionMsg;
        $envio = $this->sendMsg();
        $this->Request = $envio;
        //Save question and root
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_save_question("' . $this->wsp_id . '","' . $this->rootId . '",\'' . $this->Paciente . '\',"' . $this->patientName . '",\'' . $this->Cliente . '\',"' . $this->patientCliente . '","' . $this->patientToId . '")';
		@mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar(); 
        return $this->Request;
    }
    
    function endChat(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_360dialog_end_chat("' . $this->wsp_id . '")';
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();        
    }
    
    function prepareInputRequest(){
        $jsonIterator = new RecursiveIteratorIterator(
        new RecursiveArrayIterator(json_decode($this->input_request, TRUE)),
        RecursiveIteratorIterator::SELF_FIRST);
        $Root = "";
        $Context = "0";
        $item = 0;
        foreach ($jsonIterator as $key => $val) {
            if(is_array($val)) {
                if($key != "0"){
                    if($key == "messages"){
                        $this->type_obj = "messages";
                        $this->isMessage = "true";
                    }else if($key == "context"){
                        $this->isContext = "true";
                        $Context = "1";
                    }else if($key == "video"){
                        $this->isVideo = "true";
                    }else if($key == "image"){
                        $this->isImage = "true";
                    }else if($key == "document"){
                        $this->isDocument = "true";
                    }else if($key == "text"){
                        $this->isText = "true";
                    }else if($key == "statuses"){
                        $this->type_obj = "statuses";
                        $this->isMessage = "true";    
                    }
                    $Root = $key;
                }
            } else {
                if($Root == "context"){
                    if($key == "from" && $item == 3){
                        $this->context_from_id = $val;
                    }else if($key == "id" && $item == 4){
                        $this->context_transaction_id = $val;
                    }
                }else if($Root == "video"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }else if($Root == "image"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }else if($Root == "document"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }
                if($key == "from"){
                    $this->from_id = $val;
                }else if($key == "id"){
                    $this->transaction_id = $val;
                }else if($key == "body"){
                    $this->answer = $val;
                }else if($key == "timestamp"){
                    $this->timestamp_mov = $val;
                }else if($key == "type"){
                    $this->type_id = $val;
                }else if($key == "type"){
                    $this->type_id = $val;
                }else if($key == "name"){
                    $this->profile_name = $val;
                }else if($key == "wa_id"){
                    $this->wsp_id = $val;
                }else if($key == "mime_type"){
                    $this->media_mime_type = $val;
                }else if($key == "sha256"){
                    $this->media_sha256 = $val;
                }else if($key == "caption"){
                    $this->media_caption = $val;
                }else if($key == "filename"){
                    $this->media_filename = $val;
                }else if($key == "recipient_id"){
                    $this->recipient_id = $val;
                    $this->wsp_id = $val;
                }else if($key == "status"){
                    $this->status_id = $val;
                }
            }
            $item++;
        }
        $this->saveJson();
    }
    
    function saveJson(){
        if($this->type_obj == "messages"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = 'CALL sp_360dialog_save_messages("' . $this->response_api . '","' . $this->type_obj . '","' . $this->isMessage . '","' . $this->isContext . '","' . $this->isText . '","' . $this->isVideo . '","' . $this->isImage . '","' . $this->isDocument . '","' . $this->from_id . '","' . $this->transaction_id . '","' . $this->context_from_id . '","' . $this->context_transaction_id . '","' . $this->timestamp_mov . '","' . $this->type_id . '","' . $this->media_id . '","' . $this->media_mime_type . '","' . $this->media_sha256 . '","' . $this->media_caption . '","' . $this->media_filename . '","' . $this->answer . '","' . $this->profile_name . '","' . $this->wsp_id . '","' . $this->recipient_id . '","' . $this->status_id . '","' . $this->question . '","' . $this->contact . '","' . $this->to_id . '","' . $this->Paciente . '","' . $this->Cliente . '","' . $this->CAS . '","' . $this->FechaAct . '","' . $this->isBeginChat . '","' . $this->idchat_question . '")';
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }else if($this->type_obj == "statuses"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = 'CALL sp_360dialog_save_statuses("' . $this->response_api . '","' . $this->type_obj . '","' . $this->isMessage . '","' . $this->transaction_id . '","' . $this->timestamp_mov . '","' . $this->status_id . '","' . $this->wsp_id . '","' . $this->recipient_id . '")';
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();    
        }else{
            $file = fopen("log.txt", "a");
            fwrite($file, $this->response_api . PHP_EOL);
            fwrite($file, "----------------------------------------------" . PHP_EOL);
            fclose($file);
        }
    }
    
    function saveRootOptionsMasterId(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_set_root("' . $this->wsp_id . '","' . $this->rootId . '","' . $this->txtQuestionOpt . '")';
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
    }
    
    function callMenuOptions($opt){
        //extract menu options from database
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_get_root("' . $this->rootId . '")';
        $this-writeLog($qry);
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($opt == "Y"){
            @eval($responseQry[3]);
        }else{
            @eval($responseQry[1]);
        }
        @eval($responseQry[2]);
        $this->questionMsg = $botQuestion;
        $this->questionOpt = $botOptions;
    }
    
    function webHook(){
        $authMsg = $this->getAuthentication();
        $this->prepareInputRequest();
        /*
        $this->isBeginChat = "false";
        $this->patientBeginChat = "0";
        $this->rootId = "0";
        if($this->type_obj == "messages"){
            $this->validateAnswer();
            //Validar Chat 1 Vez
            $this->validateBeginChat();
            if($this->isBeginChat == "true"){
                //Mensaje Inicial
                $this->rootId = "0";
                $this->callMenuOptions("N");
                $this->sendQuestion();
            }else{
                if($this->answer != "{success:false}" && $this->answer != "" && $this->patientBeginChat != "1"){
                    $this->goFlowProcess();    
                }
            }
        }*/
    }
    
    function getIdChat(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_getidchat("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->Paciente = $responseQry[0];
        $this->patientToId = $responseQry[1];
        $this->patientName = $responseQry[2];
        $this->patientFirstName = "*" . $responseQry[8] . "*";
        $this->Cliente = $responseQry[3];
        $this->patientCliente = $responseQry[4];
        $this->rootId = $responseQry[5];
        @eval($responseQry[6]);
        $this->questionOpt = $botOptions;
        $this->questionNextRoot = $responseQry[7];
    }
    
    function goFlowProcess(){
        $this->getIdChat();
        switch(strtoupper($this->answer)){
            case "0":
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de *MEDICARE IPS*, te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requiere hacer otra cita, ingrese con la palabra *Ayuda*.";
                $this->sendMsg();
                $this->endChat();
                break;
            case "O":
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de *MEDICARE IPS*, te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requiere hacer otra cita, ingrese con la palabra *Ayuda*.";
                $this->sendMsg();
                $this->endChat();
                break;
            default:
                $this->validateAnswerOptionMenu();
                break;
        }
    }
    
    function getLastQuestion(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_get_lastquestion("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        @eval($responseQry[1]);
        @eval($responseQry[2]);
        $this->questionMsg = $botQuestion;
        $this->questionOpt = $botOptions;
        $this->typeAnswer = $responseQry[3];
        $this->questionTxt = $responseQry[4];
        $this->questionTimestamp = $responseQry[6];
        $this->txtQuestionOpt = $responseQry[2];
        $this->rootId = $responseQry[0];
        if($this->rootId != "" && $this->rootId != null && $this->rootId != "{success:false}" && $this->rootId != "0"){
            $this->saveRootOptionsMasterId();
        }
    }
    
    function getDataPatient(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_validate_patient("' . $this->answer . '","' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->Paciente = $responseQry[0];
        $this->patientDocument = $responseQry[1];
        //$this->patientName = $responseQry[2];
        $this->Genero = $responseQry[3];
        $this->patientToId = $responseQry[4];
	    $this->FecNac = $responseQry[5];
	    $this->WSPValido = $responseQry[7];
	    $this->patientName = "*";
	    if($responseQry[8] != "" && $responseQry[8] != null){
	        $this->patientName .= $responseQry[8];
	    }
	    if($responseQry[9] != "" && $responseQry[9] != null){
	        $this->patientName .= " " . $responseQry[9];
	    }
	    if($responseQry[10] != "" && $responseQry[10] != null){
	        $this->patientName .= " " . $responseQry[10];
	    }
	    if($responseQry[11] != "" && $responseQry[11] != null){
	        $this->patientName .= " " . $responseQry[11];
	    }
	    $this->patientName .= "*";
        $this->patientFirstName = "*" . $responseQry[8] . "*";
        $this->Exento = $responseQry[12];
        $this->Cliente = $responseQry[13];
        $this->patientEstado = $responseQry[14];
        $this->patientExisteBD = $responseQry[15];
        $this->patientCliente = $responseQry[16];
    }
    
    function validateAnswerOptionMenu(){
        $this->seloptionId = "0";
        $this->seloptionTitle = "";
        $this->seloptionFunction = "";
        $this->seloptionNextRoot = "";
        $arrIterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($this->questionOpt),RecursiveIteratorIterator::SELF_FIRST);
        $Root = "";
        $Context = "0";
        $item = 0;
        foreach ($arrIterator as $key => $val) {
            if(is_array($val)) {
                if($key != "0"){
                    $item = $key;
                }
            }else{
                if($item == strtoupper($this->answer)){
                    if($key == "opcion"){
                        $this->seloptionId = $val;
                    }else if($key == "titulo"){
                        $this->seloptionTitle = $val;
                    }else if($key == "funcion"){
                        $this->seloptionFunction = $val;
                    }else if($key == "next"){
                        $this->seloptionNextRoot = $val;
                    }
                }
            }
        }
        if($this->seloptionId == "0"){
            $this->txtBodyToSend = $this->patientFirstName . ", su respuesta no es correcta por favor verifique nuevamente.";
            $this->sendMsg();
            $this->callMenuOptions("Y");
            $this->sendQuestion();
        }else{
            $this->txtBodyToSend = "Seleccionaste " . $this->seloptionId . " - " . $this->seloptionTitle . " - Sgte: " . $this->seloptionNextRoot;
            $this->sendMsg();
            
            /*
            $this->rootId = $this->seloptionNextRoot;
            $this->callMenuOptions("N");
            $this->sendQuestion();
            */
            
            /*
    	    $this->seloptionTitle = "";
    	    $this->seloptionFunction = "";
    	    $this->seloptionNextRoot = "";
    	    */
        }
        //$this->writeLog($key . "=>" . $val);
            
    }
    
    function getSpecialtyAppointmentOpt(){
        //
    }
    
    function validateAnswer(){
        $this->getLastQuestion();
        if(strtoupper($this->answer) == "FIN" || strtoupper($this->answer) == "FINALIZAR" || strtoupper($this->answer) == "AYUDA" || strtoupper($this->answer) == "EMPEZAR" || strtoupper($this->answer) == "HOLA" || strtoupper($this->answer) == "OLA"){
            if($this->patientName != "" && $this->patientName != null && $this->patientName != "{success:false}"){
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de *MEDICARE IPS*, te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requiere hacer otra cita, ingrese con la palabra *Ayuda*.";
                $this->sendMsg();
            }
            $this->endChat();
        }else if($this->rootId != "{success:false}"){
            if($this->rootId == "0"){
                //validar Usuario
                $this->getDataPatient();
                if($this->Paciente != "" && $this->Paciente != "{success:false}"){
                    if($this->patientExisteBD != "OKBD"){
                        $this->rootId = "0";
                        $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", usted no está registrado en ninguna de las bases de datos de las EPS con las que tenemos convenio, lo invitamos a que se comunique con su EPS y lo intente posteriormente.";
                        $this->endChat();
                        $this->sendMsg();
                    }else{
                        if($this->patientEstado != "ACTIVO"){
                            $this->rootId = "0";
                            $this->txtBodyToSend = $this->patientToId . " " . $this->patientName . ", usted no está *ACTIVO* en la última base de datos de *" . $this->patientCliente . "*, lo invitamos a que se comunique con su EPS y lo intente posteriormente.";
                            $this->endChat();
                            $this->sendMsg();
                        }else{
                            if($this->WSPValido == "SI"){
                                $this->patientBeginChat = "1";
                                $this->rootId = "1";
                                $this->callMenuOptions("N");
                                $this->sendQuestion();
                            }else{
                                $this->rootId = "0";
                                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", usted aún no ha registrado este número de contacto como canal de comunicación, lo invitamos a que se registre en nuestra página: www.medicareips.com.co/registrowsp";
                                $this->endChat();
                                $this->sendMsg();
                            }
                        }
                    }
                }else{
                    $this->txtBodyToSend = "El *Documento* *" . $this->answer . "* no existe en nuestra base de datos, por favor verifique esta información.";
                    $this->endChat();
                    $this->sendMsg();
                }
            }
        }
    }
    
    function writeLog($text){
        $file = fopen("log.txt", "a");
        fwrite($file, date('h:i:s A') . " - " . $text . PHP_EOL);
        fwrite($file, "----------------------------------------------" . PHP_EOL);
        fclose($file);
    }
}